<?php
/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2010 osCommerce

  Released under the GNU General Public License
*/

  class ht_gulliver {
    var $code = 'ht_gulliver';
    var $group = 'header_tags';
    var $enabled = false;
    var $version = '1.2';
    var $title = '';
    var $description = '';
    var $api_key = '';
    var $crm_server = '';
    var $crm_account = '';

    function ht_gulliver() {
      //titre et description du module
      $this->title = LANG_MODULE_HEADER_TAGS_GULLIVER_TITLE;
      $this->description = LANG_MODULE_HEADER_TAGS_GULLIVER_DESCRIPTION;
      
      //tat du module (activ = Oui)
      $_yes = addslashes(htmlentities(LANG_MODULE_HEADER_TAGS_GULLIVER_YES));
      $this->enabled = (MODULE_HEADER_TAGS_GULLIVER_STATUS == $_yes);
      
      //recupere les 3 variables de config
      $this->api_key = MODULE_HEADER_TAGS_GULLIVER_API_KEY;
      $this->crm_server = MODULE_HEADER_TAGS_GULLIVER_CRM_SERVER;
      $this->crm_account = MODULE_HEADER_TAGS_GULLIVER_CRM_ACCOUNT;
    }
    
    public function getVersion ()
    {
      return $this->version;
    }

    //Fonction de pose des tags GTA
    function execute() {
      global $PHP_SELF, $oscTemplate, $customer_id, $current_category_id;
      #echo '<pre>';print_r($GLOBALS);echo'</pre>';
      
      //pas de GTA on arrete
      if($this->crm_server == '' || $this->crm_account == '')
        return;

      
      /* ************ DEBUT CONSTRUCTION DU CONTENU DU TAG ************ */
      //time unix
      $script_content = "var ase_time='" . time () . "';" . "\n";
      
      //identifiant du cookie ATTENTION REGENERE LORS DE L'OUVERTURE DE SESSION !!!!!!!!
      $script_content .= "var ase_id='" . addslashes ($_COOKIE['osCsid']) . "';" . "\n";
      
      // code iso de la langue de la session
      if (isset($_SESSION['languages_id']) && !empty($_SESSION['languages_id']))
      {
        $language_query = tep_db_query("SELECT code FROM " . TABLE_LANGUAGES . " where languages_id=" . (int)$_SESSION['languages_id']);
        $infos_language = tep_db_fetch_array($language_query);
        $lang = addslashes($infos_language['code']);

        if($lang != '')
          $script_content .= "var ase_lang='$lang';" . "\n"; 
      }
      
      //email du client
      if(isset($customer_id) && $customer_id != '')
      {
        $email_query = tep_db_query("SELECT customers_email_address FROM " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customer_id . "'");
        $infos_customer = tep_db_fetch_array($email_query);

        if(isset($infos_customer["customers_email_address"]) && $infos_customer["customers_email_address"] != '')
          $script_content .= "var ase_var='S01=" . addslashes ($infos_customer["customers_email_address"]) . "';" . "\n";
      }
      
      //identifiant catgorie courrante
      if($current_category_id != '')
        $script_content .= "var ase_category='" . $current_category_id . "';" . "\n";
      
      //rfrence produit courrante (construite a partir de l'id produit)
      if($_REQUEST['products_id'] != '')
      {
        $ref_product = addslashes($this->get_ProductRef_from_ProductId($_REQUEST['products_id']));
        $script_content .= "var ase_ref_product='" . $ref_product . "';" . "\n";
      }
      
      //panier
      if(isset($GLOBALS['cart']->contents) && is_array($GLOBALS['cart']->contents) && count($GLOBALS['cart']->contents) > 0)
      {
        $script_content .= "var ase_multi_cart=new Array()" . "\n";
        $script_content .= "ase_multi_cart[1]='Z;;;;;;'" . "\n";
        
        $i = 2;
        foreach($GLOBALS['cart']->contents as $id_product=>$cart_line)
        { 
          //on construit la ref  partir de l'id
          $product_ref = addslashes ($this->get_ProductRef_from_ProductId($id_product));
          
          //quantit
          $product_quantity = $cart_line['qty'];
          
          //nom
          $product_query = tep_db_query("SELECT products_name FROM " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$id_product . "'");
          $infos_product = tep_db_fetch_array($product_query);       
          $product_name = str_replace (';', '', $infos_product['products_name']);
          $product_name = addslashes($product_name);
          
          //catgorie
          $product_cat_query = tep_db_query("SELECT categories_id FROM " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$id_product . "'");
          $infos_product_cat = tep_db_fetch_array($product_cat_query);
          $product_category = addslashes($infos_product_cat['categories_id']);
          
          //prix (ou prix2)
          $product_price_query = tep_db_query("SELECT products_price FROM " . TABLE_PRODUCTS . " where products_id = '" . (int)$id_product . "'");
          $infos_product_price = tep_db_fetch_array($product_price_query);  
          $product_price2_query = tep_db_query("SELECT specials_new_products_price FROM " . TABLE_SPECIALS . " where products_id=" . (int)$id_product . " and status=1 and (expires_date>'".date("Y-m-d H:i:s")."' or expires_date='0000-00-00 00:00:00')");
          $infos_product2_price = tep_db_fetch_array($product_price2_query);  

          if($infos_product2_price != FALSE)// on a un prix 2
            $product_price = $infos_product2_price['specials_new_products_price'];
          else//prix normal
            $product_price = $infos_product_price['products_price'];
          
          $script_content .= "ase_multi_cart[$i]='A;$product_name;$product_ref;$product_price;$product_quantity;;$product_category';" . "\n";
          $i++;
        }
      }

      //confirmation de commande
      if ((basename($PHP_SELF) == FILENAME_CHECKOUT_SUCCESS) && tep_session_is_registered('customer_id') ) 
      {  
        $order_query = tep_db_query("select orders_id, customers_email_address from " . TABLE_ORDERS . " where customers_id = '" . (int)$customer_id . "' order by date_purchased desc limit 1");

        if (tep_db_num_rows($order_query) == 1) 
        {
          $order = tep_db_fetch_array($order_query);
          
          //email
          $order_email = addslashes($order['customers_email_address']);
          
          //id_order
          $order_id = (int)$order['orders_id'];
          
          //montant total
          $order_totals_query = tep_db_query("select value, class from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $order_id . "'");
          #$order_totals_infos = tep_db_fetch_array($order_totals_query); 
          while ($order_totals = tep_db_fetch_array($order_totals_query)) 
          {
            if($order_totals['class'] == 'ot_total')
            {
              $order_total = $order_totals['value'];
              break;
            }
          }

          //nombre de produits dans la commande
          $order_prod_qty = 0;
          $order_products_query = tep_db_query("select op.products_id, pd.products_name, op.final_price, op.products_quantity from " . TABLE_ORDERS_PRODUCTS . " op, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_LANGUAGES . " l where op.orders_id = '" . (int)$order['orders_id'] . "' and op.products_id = pd.products_id and l.code = '" . tep_db_input(DEFAULT_LANGUAGE) . "' and l.languages_id = pd.language_id");
          while ($order_products = tep_db_fetch_array($order_products_query)) 
          {
            $order_prod_qty = $order_prod_qty + (int)$order_products['products_quantity'];
          }
        }
        
        $script_content .= "var ase_cart='T;$order_email;$order_id;$order_total;$order_prod_qty;;'" ."\n";
      }     
      /* ************ FIN CONSTRUCTION DU CONTENU DU TAG ************ */
      
      
      //mise en forme serveur/compte GTA
      $gta_server = trim($this->crm_server);
      $gta_project = trim($this->crm_account);
      if (strpos ($gta_server, 'http://') !== FALSE)
        $gta_server = substr ($gta_server, 7);
      $gta_server = str_replace ('/', '', $gta_server);
      $gta_project = str_replace ('/', '', $gta_project);

      //url du JS du GTA
      $url_ase = 'http://' . $gta_server . '/prj/' . $gta_project . '/ase.js';
     
      //TAG FINAL
      $output = <<<EOT
<!-- BEGIN Tracking Module Gulliver -->
<script type="text/javascript"> 
<!-- // Variables GTA

$script_content

// -->
</script>
<script type="text/javascript" src="$url_ase"></script>
<!-- END Tracking Module Gulliver -->

EOT;
    
      //le tag doit tre pos dans le footer
      $this->group = 'footer_scripts';

      //pose du tag
      $oscTemplate->addBlock($output, $this->group);
    }
    
    //construit une rfrence produit format Gulliver (G!XXXXX)  partir de l'ID oscommerce du produit
    function get_ProductRef_from_ProductId ($product_id)
    {
      //////////A FAIRE GERER LES DECLINAISONS !!!! ID PROD DU TYPE 1{5}4{2}
      ///////////////////////////////////////////////////////////////////////
      ///////////////////////////////////////////////////////////////////////
      ///////////////////////////////////////////////////////////////////////
      ///////////////////////////////////////////////////////////////////////
      

      //si c'est l'id d'une declinaison on construit l'id du generique
      if(strpos ($product_id, '{'))
        $product_id = substr ($product_id, 0,  strpos ($product_id, '{'));
          
      $ref = sprintf ('G!%05d', trim($product_id));
      return $ref;
    }

    function isEnabled() {
      return $this->enabled;
    }

    function check() {
      return defined('MODULE_HEADER_TAGS_GULLIVER_STATUS');
    }

    //VARIABLES DE CONFIG MODIFIABLES VIA INTERFACE PAR L'UTILISATEUR
    function install() {
      $_module_state_title = addslashes(htmlentities('Activer le module Gulliver eMailing'));
      $_yes = addslashes(htmlentities('Oui'));
      $_no = addslashes(htmlentities('Non'));
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('$_module_state_title', 'MODULE_HEADER_TAGS_GULLIVER_STATUS', '$_yes', '', '6', '1', 'tep_cfg_select_option(array(\'$_yes\', \'$_no\'), ', now())");
      
      $_cle_acces_title = addslashes(htmlentities('Cl pour la connexion catalogue'));
      $cle_acces = $this->createNewAPIKey ();
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('$_cle_acces_title', 'MODULE_HEADER_TAGS_GULLIVER_API_KEY', '$cle_acces', '', '6', '1', now())");
      
      $_adresse_serveur_crm_title = addslashes(htmlentities('Adresse du serveur CRM'));
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('$_adresse_serveur_crm_title', 'MODULE_HEADER_TAGS_GULLIVER_CRM_SERVER', '', '', '6', '1', now())");
      
      $_nom_compte_crm_title = addslashes(htmlentities('Nom du compte CRM'));
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('$_nom_compte_crm_title', 'MODULE_HEADER_TAGS_GULLIVER_CRM_ACCOUNT', '', '', '6', '1', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_HEADER_TAGS_GULLIVER_STATUS', 'MODULE_HEADER_TAGS_GULLIVER_API_KEY', 'MODULE_HEADER_TAGS_GULLIVER_CRM_SERVER', 'MODULE_HEADER_TAGS_GULLIVER_CRM_ACCOUNT');
    }
    
    function createNewAPIKey ($len = 20)
    {
      $alphabet = ".23456789abcdefghkmnpqrstuvwxyz_{}[]()";
      $api_key = '';
      for ($i = 0; $i < $len; $i++)
      {
        $api_key .= $alphabet[rand (0, strlen ($alphabet))];
      }
      return $api_key;
    }
  }
?>
