<?php
require_once('includes/application_top.php');

define ('G_VERSION', '1.8');

define ('G_SEP', ';');
define ('G_EOL', "\n");

if (!ini_get ('safe_mode'))
{
  @set_time_limit (3600); // -1
  // @ini_set ('memory_limit', '1024M');
  @ini_set ('memory_limit', -1);
}

if($_REQUEST['do2'] && $_REQUEST['do2'] == 'version')
{
  G_do_version ();
  exit;
}

global $id_lang_for_export;
if(isset($_REQUEST["select_id_lang"]) && $_REQUEST["select_id_lang"] != '')
  $id_lang_for_export = (int)trim($_REQUEST["select_id_lang"]);
else
  $id_lang_for_export = 1;//A AMELIORER

if(isset($_REQUEST['do']) && !empty($_REQUEST['do']))
{
  // Vrif du CRC/SHA1
  $do = $_REQUEST['do'];
  $gmdate = $_REQUEST['gmdate'];
  $api_key = G_get_api_key ();
  $calc_signature = sha1 ("$gmdate$do$api_key");
  $signature = $_REQUEST['signature'];
  if ($signature != $calc_signature)
    die ('Bad signature');

  G_switch($_REQUEST['do']);//ralisation d'un export
}
else
{
  G_main ();//Affichage de l'interface
}






//Affichage de l'interface principal du module
function G_main () 
{
  //verification de la sssion
  G_verify_connection ();
  
  $gmdate = gmdate ("Y-m-d\TH:i:s\Z");
  $api_key = G_get_api_key ();
  

  $url_do_export_categories = 'ModuleGulliver.php?do=categories&signature='.urlencode (sha1 ("$gmdate"."categories"."$api_key")).'&gmdate=' . urlencode ($gmdate);
  
  $signature_do_customer =  sha1 ("$gmdate"."customer"."$api_key");
  $signature_do_categories = sha1 ("$gmdate"."categories"."$api_key");
  $signature_do_catalog = sha1 ("$gmdate"."catalog"."$api_key");
  $signature_do_orders = sha1 ("$gmdate"."orders"."$api_key");
  
  $_select_lang = G_get_select_language_for_export ();

  $today_day = date('d');
  $today_month = date('m'); 
  $today_year = date('Y'); 
  
  echo<<<EOT
<?xml version="1.0" encoding="windows-1252"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
  <head>
    <title>Module Gulliver eMailing pour OsCommerce</title>
    <style type="text/css">
      body
      {
        font-size:12px;
        font-family:arial;
      }
      #gulliver_module
      {
        background-color: #E9E9E9;
        border: 4px ridge #FF6033;
        display: block;
        float: left;
        margin: 20px;
        padding: 20px;
      }
      #gulliver_module .logo
      {
        left: 33px;
        position: absolute;
        top: 28px;
      }
      #gulliver_module .main_title
      {
        color: #FF6033;
        display: block;
        font-size: 24px;
        font-weight: bold;
        margin-bottom: 45px;
        margin-top: 10px;
        text-align: center;
        width: 100%;
      }
      #gulliver_module .encart
      {
        background-color: #FFFFF0;
        border: 2px solid #DFD5C3;
        clear: both;
        display: block;
        margin-bottom: 20px;
        padding: 10px;
      }
      #gulliver_module .encart .encart_title
      {
        clear: both;
        color: #FF6033;
        display: block;
        font-size: 16px;
        font-weight: bold;
        margin-bottom: 5px;
      }
      #gulliver_module .encart .encart_subtitle
      {
        clear: both;
        display: block;
        font-weight: bold;
        margin-left: 20px;
        margin-bottom: 10px;
      }
      #gulliver_module .encart .encart_selectlang
      {
        clear: both;
        display: block;
        margin-bottom: 10px;
        margin-left: 20px;
      }
      #gulliver_module .encart .encart_selectlang label
      {
      }
      #gulliver_module .encart .encart_selectlang input
      {
      }
      #gulliver_module .encart .encart_select_date
      {
        clear: both;
        display: block;
        margin-bottom: 10px;
        margin-left: 20px;
      }
      #gulliver_module .encart .encart_submit
      {
        clear: both;
        display: block;
        margin-left: 100px;
      }
      #gulliver_module .encart .encart_submit a,
      #gulliver_module .encart .encart_submit input
      {
        background-color: #FFF6D3;
        border: 1px double #BBBBBB;
        color: #268CCD;
        display: block;
        font-family: arial;
        font-size: 12px;
        font-weight: bold;
        padding: 5px;
        text-align: center;
        text-decoration: none;
        width: 150px;
      }
      #gulliver_module .encart .encart_description
      {
        clear: both;
        display: block;
        font-style: italic;
        margin-left: 20px;
        margin-top: 10px;
      }
    </style>
  </head>
  <body>
    <div id="gulliver_module">
      <div class="logo"><img src="http://www.gulliver.com/gfm/530098/m/img/header_logo.png" alt="Gulliver.com" height="80" width="199" /></div>
      <div class="main_title">Module Gulliver eMailing</div>

      <!-- DEBUT EXPORT CONTACTS -->
      <div class="encart">
        <div class="encart_title">
          Gulliver Export Contacts
        </div>
        <div class="encart_subtitle">
          Exporter les contacts vers Gulliver eMailing
        </div>
        <form action="ModuleGulliver.php" method="post">
          <input type="hidden" name="do" value="customer" />
          <input type="hidden" name="gmdate" value="$gmdate" />
          <input type="hidden" name="signature" value="$signature_do_customer" />
          <div class="encart_select_date">
            R&eacute;cup&eacute;rer les contacts cr&eacute;es/modifi&eacute;s &agrave; partir du : 
            <input type="text" value="$today_day" name="begin_date_day" maxlength="2" size="2" /> / 
            <input type="text" value="$today_month" name="begin_date_month" maxlength="2" size="2" /> / 
            <input type="text" value="$today_year" name="begin_date_year" maxlength="4" size="4" />
          </div>
          <div class="encart_submit">
            <input type="submit" value="Exporter les contacts" />
          </div>
        </form>
        <div class="encart_description">
          L'export des contacts est &agrave; faire pour mettre &agrave; jour les contacts pour vos eMailings.<br/>
          Si vous avez choisi l'option "Connexion Catalogue", vous avez la possibilit&eacute; d'automatiser ce transfert.
        </div>
      </div>
      <!-- FIN EXPORT CONTACTS -->
      
      <!-- DEBUT EXPORT CATEGORIES -->
      <div class="encart">
        <div class="encart_title">
          Gulliver Export Categories
        </div>
        <div class="encart_subtitle">
          Exporter les cat&eacute;gories vers Gulliver eMailing
        </div>
        <form action="ModuleGulliver.php" method="post">
          <input type="hidden" name="do" value="categories" />
          <input type="hidden" name="gmdate" value="$gmdate" />
          <input type="hidden" name="signature" value="$signature_do_categories" />
          <div class="encart_selectlang">
            <label>Langue d'export : </label>$_select_lang
          </div>
          <div class="encart_submit">
            <input type="submit" value="Exporter les cat&eacute;gories" />
          </div>
        </form>
        <div class="encart_description">
          La synchronisation des cat&eacute;gories est &agrave; faire &agrave; chaque modification de l'arborescence des cat&eacute;gories principales.<br/>
          Rappel : Les cat&eacute;gories commen&ccedil;ant par G$ sont utilis&eacute;es pour indiquer les produits &agrave; inclure dans un emailing ( par exemple: G\$Newsletter )
        </div>
      </div>
      <!-- FIN EXPORT CATEGORIES -->
      
      <!-- DEBUT EXPORT CATALOGUE -->
      <div class="encart">
        <div class="encart_title">
          Gulliver Export Produits
        </div>
        <div class="encart_subtitle">
          Synchronisation des produits vers Gulliver eMailing
        </div>
        <form action="ModuleGulliver.php" method="post">
          <input type="hidden" name="do" value="catalog" />
          <input type="hidden" name="gmdate" value="$gmdate" />
          <input type="hidden" name="signature" value="$signature_do_catalog" />
          <div class="encart_select_date">
            R&eacute;cup&eacute;rer les produits cr&eacute;es/modifi&eacute;s &agrave; partir du : 
            <input type="text" value="$today_day" name="begin_date_day" maxlength="2" size="2" /> / 
            <input type="text" value="$today_month" name="begin_date_month" maxlength="2" size="2" /> / 
            <input type="text" value="$today_year" name="begin_date_year" maxlength="4" size="4" />
          </div>
          <div class="encart_selectlang">
            <label>Langue d'export : </label>$_select_lang
          </div>
          <div class="encart_submit">
            <input type="submit" value="Exporter le catalogue" />
          </div>
        </form>
        <div class="encart_description">
          L'export des produits est &agrave; faire &agrave; chaque fois que vous pr&eacute;parez un emailing incluant des produits.<br/>
          Si vous avez choisi l'option "Connexion Catalogue", vous avez la possibilit&eacute; d'automatiser ce transfert.
        </div>
      </div>
      <!-- FIN EXPORT CATALOGUE -->
      
      <!-- DEBUT EXPORT COMMANDES -->
      <div class="encart">
        <div class="encart_title">
          Gulliver Export Commandes
        </div>
        <div class="encart_subtitle">
          Synchronisation des commandes vers Gulliver eMailing
        </div>
        <form action="ModuleGulliver.php" method="post">
          <input type="hidden" name="do" value="orders" />
          <input type="hidden" name="gmdate" value="$gmdate" />
          <input type="hidden" name="signature" value="$signature_do_orders" />
          <div class="encart_select_date">
            R&eacute;cup&eacute;rer les commandes cr&eacute;es/modifi&eacute;s &agrave; partir du : 
            <input type="text" value="$today_day" name="begin_date_day" maxlength="2" size="2" /> / 
            <input type="text" value="$today_month" name="begin_date_month" maxlength="2" size="2" /> / 
            <input type="text" value="$today_year" name="begin_date_year" maxlength="4" size="4" />
          </div>
          <div class="encart_submit">
            <input type="submit" value="Exporter les commandes" />
          </div>
        </form>
        <div class="encart_description">
          L'export des commandes est &agrave; faire pour mettre &agrave; jour la segmentation de votre base clients et pour le ReTargeting eMailing.
        </div>
      </div>
      <!-- FIN EXPORT COMMANDES -->

    </div><!-- FIN gulliver_module -->
  </body>
</html>
EOT;
  
  return;
}


//Switch diffrents exports
function G_switch ($do) 
{
  
  switch ($do) {
    case 'customer':
      G_do_export_customers ();
      break;
    case 'categories':
      G_do_export_categories ();
      break;
    case 'catalog':
      G_do_export_catalog ();
    case 'orders':
      G_do_export_orders ();
      break;
    case 'test':
      G_do_test ();
      break;
    case 'version2':
      G_do_version ('EXTENDED');
      break;
    case 'search_order':
      G_do_search_order ();
      break;
    default:
      G_main ();
      break;
  }

  return;
}

//Fichier Export des contacts
function G_do_export_customers () 
{
  /*
    POINTS A AMELIORER

    "type_contact"
    Actuellement => si le client a pass au moins une commande => c'est un client
    ==> normalement on devrait vrifier le status pour vrifier que la commande a t paye
    Mais pb l'utilisateur peut configurer les status comme il veut (id diffrents selon les stores)
   */
  
  //recupere la date saisie (date a partir de laquelle il faut exporter)
  //verifie le format
  //retourne la date au format "anne-mois-jour HH:MM:SS"
  $date_begin_export = G_check_export_date ($_REQUEST['begin_date_day'],$_REQUEST['begin_date_month'],$_REQUEST['begin_date_year']);

  header ('Content-Type: text/csv; charset=iso-8859-1');
  header ('Content-Disposition: attachment; filename=export_customer_' . date ('dmY') . '_' . date ('His') . '.csv');

  //ENTETES DES COLONNES DU FICHIER D'EXPORT
  $Theader = Array("EMAIL", "GENRE", "NOM", "PRENOM", "ADRESSE", "ADRESSE2", "CODE_POSTAL", "VILLE", "PAYS", "TELEPHONE", "MOBILE", "TYPE_CONTACT", "BIRTHDAY", "NEWSLETTER", "OPTIN");
  G_displayLine ($Theader, false);

  //CONTENU DU FICHIER
  $query = "SELECT *,
          (SELECT 1 FROM " . TABLE_ORDERS . " o where o.customers_id=c.customers_id GROUP BY customers_id LIMIT 0,1) AS type_contact,
          (SELECT customers_info_date_account_created FROM " . TABLE_CUSTOMERS_INFO ." ci WHERE c.customers_id=ci.customers_info_id LIMIT 0,1) as date_creation,
          (SELECT customers_info_date_account_last_modified FROM " . TABLE_CUSTOMERS_INFO ." ci WHERE c.customers_id=ci.customers_info_id LIMIT 0,1) as date_update
          FROM " . TABLE_CUSTOMERS . " c
          LEFT JOIN " . TABLE_ADDRESS_BOOK . " ad ON c.customers_default_address_id=ad.address_book_id";
  $sql = tep_db_query ($query);
  while ($Tsql = tep_db_fetch_array ($sql)) {
    
    //ON EXPORTE SEULEMENT SI DATE CREATION/UPDATE POSTERIEURE A LA DATE CHOISIT
    if(($Tsql['date_creation'] > $date_begin_export) ||($Tsql['date_update'] != NULL && $Tsql['date_update'] > $date_begin_export))
    {  

      $Tdata = Array();

      //email
      $Tdata[] = $Tsql["customers_email_address"];

      //genre
      if ($Tsql["customers_gender"] == 'm')
        $Tdata[] = "MONSIEUR";
      else if ($Tsql["customers_gender"] == 'f')
        $Tdata[] = "MADAME";
      else
        $Tdata[] = "";

      //nom
      $Tdata[] = $Tsql["customers_lastname"];
      //prenom
      $Tdata[] = $Tsql["customers_firstname"];
      //adresse 1
      $Tdata[] = $Tsql["entry_street_address"];
      //adresse 2
      $Tdata[] = $Tsql["entry_suburb"];
      //code postal
      $Tdata[] = $Tsql["entry_postcode"];
      //ville
      $Tdata[] = $Tsql["entry_city"];
      //pays 
      $Tdata[] = G_get_iso_code_from_id_country_oscommerce (trim ($Tsql["entry_country_id"]));

      //telephone => oscommerce propose un seul champ pour le telephone (pas de distinction fixe/mobile)
      if ((substr ($Tsql["customers_telephone"], 0, 2) == '06') || (substr ($Tsql["customers_telephone"], 0, 2) == '07')) {
        $Tdata[] = ""; //fixe
        $Tdata[] = $Tsql["customers_telephone"]; //mobile
      } else {
        $Tdata[] = $Tsql["customers_telephone"]; //fixe
        $Tdata[] = ""; //mobile
      }

      //type client => au moins 1 commande passe c'est un CLIENT
      if ($Tsql['type_contact'] == 1)
        $Tdata[] = 'CLIENT';
      else
        $Tdata[] = 'PROSPECT';

      //date naissance => elle contient l'heure on la supprime
      $Tdata[] = substr ($Tsql["customers_dob"], 0, 10);

      //newsletter
      $Tdata[] = $Tsql["customers_newsletter"];

      //OPTIN
      $Tdata[] = "";

      G_displayLine ($Tdata, false);
    }
  }

  exit;
}


//Fichier export des catgories
function G_do_export_categories ()
{
  global $id_lang_for_export;
  header ('Content-Type: text/csv; charset=iso-8859-1');
  header ('Content-Disposition: attachment; filename=export_categories_' . date ('dmY') . '_' . date ('His') . '.csv');
  
  $Theader = array("EXTERNAL_REF_CAT", "NOM", "TXT", "EXTERNAL_REF_CAT_MERE", "VISIBLE");
  G_displayLine ($Theader);
  
  //langue d'export choisie
  $query = "SELECT categories_id, parent_id,
            (SELECT categories_name FROM " . TABLE_CATEGORIES_DESCRIPTION . " d where c.categories_id=d.categories_id and language_id=$id_lang_for_export LIMIT 0,1) AS categories_name
            FROM " . TABLE_CATEGORIES ." c order by parent_id, categories_id";
  
  $sql = tep_db_query ($query);
  
  $Tcategories = array ();
  $Tindex = array ();
  while ($Tsql = tep_db_fetch_array ($sql)) 
  {
    $Tcategories[ $Tsql['categories_id'] ] = $Tsql;
    $Tindex[  $Tsql['categories_id'] ] =  $Tsql['parent_id'];
  }
  
  // Tri et affichage
  $Tparent = array(0);
  $Tcache = array(0 => true);
  do
  {
    $Tnew_parent = array();
    foreach ($Tcategories as $id_category => $Tcategory)
    {
      if (isset ($Tcache [$id_category]))
        continue;
      if (in_array ($Tcategory['parent_id'], $Tparent))
        {
          $Tcache [$id_category] = true;
          $Tnew_parent [] = $id_category;
          
          $Tdata2 = array();
          $Tdata2[] = $Tcategory['categories_id'];
          $Tdata2[] = $Tcategory['categories_name'];
          $Tdata2[] = '';
          $Tdata2[] = $Tcategory['parent_id'];
          $Tdata2[] = 1;

          G_displayLine ($Tdata2);
          // unset( $Tcategories[$id_category] );
        }
    }
    $Tparent = $Tnew_parent;
  } while (count ($Tparent) > 0);
  
  exit;
}


//FIchier export catalogue
function G_do_export_catalog ()
{
  /*
    POINTS A AMELIORER

    - cette version ne traite pas les dclinaisons
   
    - les produits dans OsCommerce peuvent etre multi-catgories - ici on ne prend que la 1ere catgorie d'appartenance que l'on trouve
   */
  
  global $id_lang_for_export;
  
  //recupere la date saisie (date a partir de laquelle il faut exporter)
  //verifie le format
  //retourne la date au format "anne-mois-jour HH:MM:SS"
  $date_begin_export = G_check_export_date ($_REQUEST['begin_date_day'],$_REQUEST['begin_date_month'],$_REQUEST['begin_date_year']);

  
  header ('Content-Type: text/csv; charset=iso-8859-1');
  header ('Content-Disposition: attachment; filename=export_product_' . date ('dmY') . '_' . date ('Hi') . '.csv');

  // Ligne d'entte
  $Theader = array(
      "EXTERNAL_REF_CAT",
      "REF", "REF_GENERIQUE", "NOM",
      "PRIX", "PRIX2", "PRIX3", "TAUX_TVA", "PRIX_HT", "PRIX2_HT", "PRIX3_HT",
      "MARQUE", "REF_MARQUE", "TXT1", "TXT2", "TZOOM1", "TZOOM2", "COEFF", "AFFICHER",
      "VENTE", "DEBUT_DISPO", "FIN_DISPO", "QTE_IMPOSE", "LISTE", "SI", "SS1", "SS2",
      "ORDRE", 'G$_NOM_TAG_EVENT', 'NOM_TAG_NAVIGATION',
      "SUPPLIER_CODE", "SUPPLIER_REF", "SUPPLIER_PRICE",
      'VIG', 'URL_EXTERNE', 'SA',
      'ADDITIONAL_TAX',
      'CODE_EAN', 'AVAIL_INFO',
      'CELL_B1');//CELL_B1 utilise pour stocker la rfrence interne a perles&co du produit
  
  
  // Liste des langues.
  $Tlanguages = G_get_languages_infos();
  $lettre = 'C';//on stocke les infos produits en fonction de la langue  partir de la colonne C (car colonne A ddie aux dclinaisons + B pour variables diverses)
  foreach ($Tlanguages as $Tlanguage)
  {
      $Theader[] = 'CELL_'.$lettre.'1'; // Code langue
      $Theader[] = 'CELL_'.$lettre.'2'; // Nom produit
      $Theader[] = 'CELL_'.$lettre.'3'; // Prix 1 TTC dans la langue
      $Theader[] = 'CELL_'.$lettre.'4'; // Prix 1 HT dans la langue
      $Theader[] = 'CELL_'.$lettre.'5'; // Prix 2 TTC dans la langue
      $Theader[] = 'CELL_'.$lettre.'6'; // Prix 2 HT dans la langue
      $Theader[] = 'CELL_'.$lettre.'7'; // Devise

      $lettre++;
  }
  
  G_displayLine ($Theader, true);
  
  $query = "SELECT products_id, products_price, manufacturers_id, products_quantity, products_model, products_image, products_status, products_date_available, products_tax_class_id, products_date_added, products_last_modified, 
            (SELECT products_name FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id=pd.products_id and pd.language_id=$id_lang_for_export LIMIT 0,1) AS product_name,
            (SELECT products_description FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id=pd.products_id and pd.language_id=$id_lang_for_export LIMIT 0,1) AS product_description,
            (SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS . " m where p.manufacturers_id=m.manufacturers_id LIMIT 0,1) AS manufacturer_name,
            (SELECT specials_new_products_price FROM " . TABLE_SPECIALS . " s where p.products_id=s.products_id and s.status=1 and (s.expires_date>'".date("Y-m-d H:i:s")."' or expires_date='0000-00-00 00:00:00') LIMIT 0,1) AS price2_HT,
            (SELECT tax_rate FROM " . TABLE_TAX_RATES . " tr where p.products_tax_class_id=tr.tax_class_id and tr.tax_priority=1 LIMIT 0,1) AS tax_rate
            FROM " . TABLE_PRODUCTS ." p";
  
    /*$query = "SELECT products_id, products_price, manufacturers_id, products_quantity, products_image, products_status, products_date_available, products_tax_class_id, products_date_added, products_last_modified, 
            (SELECT categories_id FROM " . TABLE_PRODUCTS_TO_CATEGORIES . " ptc where p.products_id=ptc.products_id) AS category_id,
            (SELECT categories_name FROM " . TABLE_CATEGORIES_DESCRIPTION . " cd where category_id=cd.categories_id and cd.language_id=$id_lang_for_export) AS category_name,
            (SELECT products_name FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id=pd.products_id and pd.language_id=$id_lang_for_export) AS product_name,
            (SELECT products_description FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id=pd.products_id and pd.language_id=$id_lang_for_export) AS product_description,
            (SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS . " m where p.manufacturers_id=m.manufacturers_id) AS manufacturer_name,
            (SELECT specials_new_products_price FROM " . TABLE_SPECIALS . " s where p.products_id=s.products_id and s.status=1 and (s.expires_date>'".date("Y-m-d H:i:s")."' or expires_date='0000-00-00 00:00:00')) AS price2_HT,
            (SELECT tax_rate FROM " . TABLE_TAX_RATES . " tr where p.products_tax_class_id=tr.tax_class_id) AS tax_rate
            FROM " . TABLE_PRODUCTS ." p";*/
  
  $sql = tep_db_query ($query);
  
  while ($Tsql = tep_db_fetch_array ($sql)) 
  {
    #echo '<pre>';
    #var_dump($Tsql);
    #echo '</pre><br/><br/>';
    #exit;
    
    //ON EXPORTE SEULEMENT SI DATE CREATION/MODIF POSTERIEURE A DATE CHOISIE
    if(($Tsql["products_date_added"] > $date_begin_export)||($Tsql["products_last_modified"] != NULL && $Tsql["products_last_modified"] > $date_begin_export))
    {
      //on recupere la 1ere cat d'appartenance du produit
      $query2 = "SELECT categories_id FROM " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id=".(int)$Tsql["products_id"];
      $sql2 = tep_db_query ($query2);
      $Tsql2 = tep_db_fetch_array ($sql2);
      $Tsql['category_id'] = $Tsql2["categories_id"];
      //recupere le nom de cette catgorie
      $query3 = "SELECT categories_name FROM " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id=".(int)$Tsql['category_id']." and language_id=$id_lang_for_export";
      $sql3 = tep_db_query ($query3);
      $Tsql3 = tep_db_fetch_array ($sql3);
      $Tsql["category_name"] = $Tsql3["categories_name"];   
      
      
      $Tprice = Array ();
      $Tdata = Array ();

      if($Tsql["tax_rate"] > 0)
        $tva_rate = $Tsql["tax_rate"];
      else
        $tva_rate = 0;

      #if($Tsql['category_id'] == 0){$Tsql['category_id'] = 10;}//categorie par dfaut sur les boutiques eMailing = 10
      $Tdata[] = $Tsql['category_id'];#EXTERNAL_REF_CAT => category_id

      #Cette version ne gre pas les dclinaisons donc REF_GENERIQUE toujours vide
      $Tdata[] = G_get_ProductRef_from_ProductId($Tsql["products_id"]);
      $Tdata[] = '';#REF_GENERIQUE => $ref = G_get_ProductRef_from_ProductId($Tsql["products_id"]);

      $Tdata[] = $Tsql["product_name"];#NOM => product_name

      if($tva_rate>0)
      {
        $Tdata[] = number_format(round($Tsql["products_price"]*(1+($tva_rate/100)),2), 2, '.', '');#PRIX
        $Tprice["PRIX_TTC"] = number_format(round($Tsql["products_price"]*(1+($tva_rate/100)),2), 2, '.', '');
      }
      else
      {
        $Tdata[] = number_format(round($Tsql["products_price"],2), 2, '.', '');#PRIX
        $Tprice["PRIX_TTC"] = number_format(round($Tsql["products_price"],2), 2, '.', '');        
      }
      
      if($Tsql["price2_HT"] != '')
      {
        if($tva_rate>0)
        {
          $Tdata[] = number_format(round($Tsql["price2_HT"]*(1+($tva_rate/100)),2), 2, '.', '');#PRIX2
          $Tprice["PRIX2_TTC"] = number_format(round($Tsql["price2_HT"]*(1+($tva_rate/100)),2), 2, '.', '');
        }
        else
        {
          $Tdata[] = number_format(round($Tsql["price2_HT"],2), 2, '.', '');#PRIX2
          $Tprice["PRIX2_TTC"] = number_format(round($Tsql["price2_HT"],2), 2, '.', '');          
        }
      }
      else
      {
        $Tdata[] = '';#PRIX2
        $Tprice["PRIX2_TTC"] = '';
      }

      $Tdata[] = '';#PRIX3
      
      if($tva_rate>0)
        $Tdata[] = number_format($tva_rate, 2, '.', '');#TAUX_TVA
      else
        $Tdata[] = '';

      $Tdata[] = number_format(round($Tsql["products_price"],2), 2, '.', '');#"PRIX_HT" => products_price
      $Tprice["PRIX_HT"] = number_format(round($Tsql["products_price"],2), 2, '.', '');

      if($Tsql["price2_HT"] != NULL)
      {
        $Tdata[] = number_format(round($Tsql["price2_HT"],2), 2, '.', '');#PRIX2_HT => price2_HT 
        $Tprice["PRIX2_HT"] = number_format(round($Tsql["price2_HT"],2), 2, '.', '');
      }
      else
      {
        $Tdata[] = '';#PRIX2_HT
        $Tprice["PRIX2_HT"] = '';
      }
      
      $Tdata[] = '';#PRIX3_HT

      $Tdata[] = $Tsql["manufacturers_name"];#"MARQUE" => manufacturers_name

      $Tdata[] = '';#REF_MARQUE
      $Tdata[] = '';#TXT1

      $Tdata[] = $Tsql["product_description"];#"TXT2" => product_description

      $Tdata[] = '';#TZOOM1
      $Tdata[] = '';#TZOOM2
      $Tdata[] = '';#COEFF

      $Tdata[] = $Tsql["products_status"];#AFFICHER => products_status 

      
      if($Tsql["products_date_available"] == '0000-00-00 00:00:00'){$Tsql["products_date_available"] = '';}
      
      if($Tsql["products_date_available"] != NULL)
      {
        preg_match ('/^(....)-(..)-(..) (..):(..):(..)$/', $Tsql["products_date_available"], $T);
        $YEAR_available = $T[1];
        $MONTH_available = $T[2];
        $DAY_available = $T[3];
        $HOUR_available = $T[4];
        $MINUTE_available = $T[5];
        $SECOND_available = $T[6];

        $unix_time_available = mktime($HOUR_available, $MINUTE_available, $SECOND_available, $MONTH_available, $DAY_available, $YEAR_available);

        if($Tsql["products_status"] == 1 && $unix_time_available < mktime())
          $Tdata[] = 1;#VENTE => products_status + le products_date_available doit etre une date inferieure a aujoud'hui
        else
          $Tdata[] = 0;#VENTE
      }
      else
      {
        $Tdata[] = $Tsql["products_status"];#VENTE
      }

      $Tdata[] = $Tsql["products_date_available"];#DEBUT_DISPO

      $Tdata[] = '';#FIN_DISPO
      $Tdata[] = '';#QTE_IMPOSE
      $Tdata[] = '';#LISTE
      $Tdata[] = '';#SI
      $Tdata[] = '';#SS1
      $Tdata[] = '';#SS2
      $Tdata[] = '';#ORDRE
      $Tdata[] = '';#G$_NOM_TAG_EVENT

      $Tdata[] = $Tsql["category_name"];#NOM_TAG_NAVIGATION => category_name

      $Tdata[] = $Tsql["manufacturers_name"];#SUPPLIER_CODE

      $Tdata[] = '';#SUPPLIER_REF
      $Tdata[] = '';#SUPPLIER_PRICE

      if($Tsql["products_image"] != '')
        $Tdata[] = 'http://' . $_SERVER['HTTP_HOST'] . '/images/' . $Tsql["products_image"];#VIG
      else
        $Tdata[] = '';#VIG

      $Tdata[] = 'http://' . $_SERVER['HTTP_HOST'] . '/product_info.php?products_id=' . $Tsql["products_id"];#URL_EXTERNE

      $Tdata[] = $Tsql["products_quantity"];#SA

      $Tdata[] = '';#ADDITIONAL_TAX
      $Tdata[] = '';#CODE_EAN
      $Tdata[] = '';#AVAIL_INFO

      $Tdata[] = $Tsql['products_model'];#rfrence interne du produit
      
      //noms des produits en fonction de la langue
      $query2 = 'SELECT language_id, products_name ' .
              'FROM ' . TABLE_PRODUCTS_DESCRIPTION . ' WHERE products_id = ' . (int)$Tsql["products_id"];
      $sql2 = tep_db_query ($query2);
      $Tname_by_lang = Array ();
      while ($Tsql2 = tep_db_fetch_array ($sql2)) 
      {
        $Tname_by_lang[$Tsql2["language_id"]] = $Tsql2["products_name"]; 
      }
      
      //devise par dfaut
      $default_currency = $GLOBALS["HTTP_SESSION_VARS"]["currency"];
      
      // Infos en fcot de la langue
      foreach ($Tlanguages as $Tlanguage)
      {
          $Tdata[] = $Tlanguage['code'];// Code langue
          $Tdata[] = $Tname_by_lang[$Tlanguage["id_lang"]]; // Nom produit
          $Tdata[] = $Tprice["PRIX_TTC"]; // Prix 1 TTC dans la langue
          $Tdata[] = $Tprice["PRIX_HT"]; // Prix 1 HT dans la langue
          $Tdata[] = $Tprice["PRIX2_TTC"]; // Prix 2 TTC dans la langue
          $Tdata[] = $Tprice["PRIX2_HT"]; // Prix 2 HT dans la langue          
          $Tdata[] = $default_currency; // Devise
      }
  
      G_displayLine ($Tdata, true);
    }
  }
  
  exit;
}


//Export commandes format XML
function G_do_export_orders ()
{
   /*
    A AMELIORER

    donnes manquantes dans l'export :
     payment_state => les tats sont configurables par le client, on ne sait donc pas quel tat correspond  une commande valide (ou pas)
     discount_amount => les rductions sont gres via module, pas d'info sur la rduction dans la base
     amount_without_tax => on peut le calculer en faisant la somme des prix des produits HT MAIS dans ce cas il faut dduire la rduction si il y'en a une 
     shipping_name => pas d'info sur le shipping dans la base (hormis le cout), gr via module
     
    PB firstname/lastname => ils sont concatns dans une meme varible 
      a partir de l'id client on peut recuperer dans la base name et firstname (mais pas possible pour l'adresse de livraison)
   */
  
  //recupere la date saisie (date a partir de laquelle il faut exporter)
  //verifie le format
  //retourne la date au format "anne-mois-jour HH:MM:SS"
  $date_begin_export = G_check_export_date ($_REQUEST['begin_date_day'],$_REQUEST['begin_date_month'],$_REQUEST['begin_date_year']);

  //Tableau de correspondance ID STATUS => STATUS NAME
  $TOrder_status = G_get_correspondence_OrderStatusNames_OrderStatusId ();

  $query = "SELECT orders_id, customers_id, date_purchased, customers_name, customers_street_address, customers_suburb, 
                   customers_telephone, customers_email_address, customers_city, customers_postcode, customers_country, 
                   customers_company, delivery_name, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, 
                   delivery_country, currency, payment_method, last_modified, orders_status,
            (SELECT value FROM " . TABLE_ORDERS_TOTAL . " ot WHERE o.orders_id=ot.orders_id AND ot.class='ot_total' LIMIT 0,1) AS amount_ttc_total,
            (SELECT value FROM " . TABLE_ORDERS_TOTAL . " ot WHERE o.orders_id=ot.orders_id AND ot.class='ot_shipping' LIMIT 0,1) AS amount_ttc_shipping,
            (SELECT value FROM " . TABLE_ORDERS_TOTAL . " ot WHERE o.orders_id=ot.orders_id AND ot.class='ot_subtotal' LIMIT 0,1) AS amount_ttc_total_without_shipping
            FROM " . TABLE_ORDERS ." o";

  $sql = tep_db_query ($query);

  $XML_SaleOrderlist = '';
  while ($Tsql = tep_db_fetch_array ($sql)) 
  {
    #echo '<pre>';
    #var_dump($Tsql);
    #echo '</pren>';
    #echo '<br/><br/><br/>';
    
    //on exporte seulement si date ajout/modif posterieure a date choisie
    if(($Tsql["date_purchased"] > $date_begin_export)||($Tsql["last_modified"] != NULL && $Tsql["last_modified"] > $date_begin_export))
    {
      //general
      $id_order_oscommerce = G_XE($Tsql["orders_id"]);
      $order_date = G_XE($Tsql["date_purchased"]);

      //customer info
      $customer_lastname = $customer_firstname = G_XE($Tsql["customers_name"]); //prenom nom
      $customer_addressline1 = G_XE($Tsql["customers_street_address"]); //adr1
      $customer_addressline2 = G_XE($Tsql["customers_suburb"]); //adr2
      $customer_phone = G_XE($Tsql["customers_telephone"]);
      $customer_email = G_XE($Tsql["customers_email_address"]);
      $customer_city = G_XE($Tsql["customers_city"]);
      $customer_postcode = G_XE($Tsql["customers_postcode"]);
      $customer_country = G_XE(G_get_iso_code_from_country_name_oscommerce($Tsql["customers_country"]));
      $customer_company = G_XE($Tsql["customers_company"]);

      //delivery info
      $delivery_lastname = $delivery_firstname = G_XE($Tsql["delivery_name"]);//prenom nom
      $delivery_addressline1 = G_XE($Tsql["delivery_street_address"]);
      $delivery_addressline2 = G_XE($Tsql["delivery_suburb"]);
      $delivery_city = G_XE($Tsql["delivery_city"]);
      $delivery_postcode = G_XE($Tsql["delivery_postcode"]);
      $delivery_country = G_XE(G_get_iso_code_from_country_name_oscommerce($Tsql["delivery_country"]));

      //total
      $total_amount = G_XE(number_format($Tsql["amount_ttc_total"], 2, ',', ''));
      $discount_amount = '';
      $currency_code = G_XE($Tsql["currency"]);
      $payment_state = G_XE($TOrder_status[$Tsql["orders_status"]]);//paymeny state => orders_status => recuperer sa traduction    

      //payment list
      $payment_method = $payment_name = G_XE($Tsql["payment_method"]);
      $payment_amount = G_XE(number_format($Tsql["amount_ttc_total"], 2, ',', ''));
      $amount_without_tax = '';
      $amount_without_shipping = G_XE(number_format($Tsql["amount_ttc_total_without_shipping"], 2, ',', ''));

      //shipping cost list
      $shipping_name = '';
      $shipping_amount = G_XE(number_format($Tsql["amount_ttc_shipping"], 2, ',', '')); 

      //lignes produits
      //REQUETE POUR RECUPERER LES INFOS DES PRODUITS ASSOCIES A LA COMMANDE
      $lignes_produit = '';
      $id_line = 1;
      $queryProductsLines = "SELECT * ". "
                             FROM " . TABLE_ORDERS_PRODUCTS ."
                             WHERE orders_id=" . $id_order_oscommerce;
      $sqlProductsLines = tep_db_query ($queryProductsLines);
      while ($TsqlProductsLines = tep_db_fetch_array ($sqlProductsLines)) 
      {
        $product_id = G_XE($TsqlProductsLines['products_id']);
        $product_quantity = G_XE($TsqlProductsLines['products_quantity']);
        $product_name = G_XE($TsqlProductsLines['products_name']);
        $product_unitPrice = G_XE($TsqlProductsLines['products_price']);
        $product_price = G_XE($TsqlProductsLines['final_price']);
        $product_vatRate = G_XE($TsqlProductsLines['products_tax']);
        
        //Ref format Gulliver ? (comme pour l'import catalogue)
        $product_ref = G_XE(G_get_ProductRef_from_ProductId($TsqlProductsLines['products_id']));
        
        
        $lignes_produit .=<<<EOT
      <SaleOrderLine line="$id_line">
        <ProductId>$product_id</ProductId>
        <Quantity>$product_quantity</Quantity>
        <Name>$product_name</Name>
        <ProductCode>$product_ref</ProductCode>
        <UnitPrice>$product_unitPrice</UnitPrice>
        <Price>$product_price</Price>
        <VAT_Rate>$product_vatRate</VAT_Rate>
      </SaleOrderLine>
EOT;
        $id_line++;
      }
      
      
      
      

      $XML_SaleOrderlist .=<<<EOT
  <SaleOrder>

    <OrderNumber>$id_order_oscommerce</OrderNumber>
    <OrderDate>$order_date</OrderDate>

    <CustomerInfo>
      <LastName>$customer_lastname</LastName>
      <FirstName>$customer_firstname</FirstName>
      <AddressLine1>$customer_addressline1</AddressLine1>
      <AddressLine2>$customer_addressline2</AddressLine2>
      <PhoneNumber>$customer_phone</PhoneNumber>
      <Email>$customer_email</Email>
      <City>$customer_city</City>
      <PostCode>$customer_postcode</PostCode>
      <CountryCode>$customer_country</CountryCode>
      <Company>$customer_company</Company>
    </CustomerInfo>

    <DeliveryInfo>
      <LastName>$delivery_lastname</LastName>
      <FirstName>$delivery_firstname</FirstName>
      <AddressLine1>$delivery_addressline1</AddressLine1>
      <AddressLine2>$delivery_addressline2</AddressLine2>
      <City>$delivery_city</City>
      <PostCode>$delivery_postcode</PostCode>
      <CountryCode>$delivery_country</CountryCode>
    </DeliveryInfo>

    <TotalAmount>$total_amount</TotalAmount>
    <Discount>$discount_amount</Discount>
    <CurrencyCode>$currency_code</CurrencyCode>
    <PaymentState>$payment_state</PaymentState>

    <PaymentList>
      <Payment>
        <PaymentMethod>$payment_method</PaymentMethod>
        <PaymentTitle>$payment_name</PaymentTitle>
        <PaymentValue>$payment_amount $currency_code</PaymentValue>
        <Amount>$payment_amount</Amount>
        <Amount_Without_Tax>$amount_without_tax</Amount_Without_Tax>
        <Amount_Without_Shipping>$amount_without_shipping</Amount_Without_Shipping>
      </Payment>
    </PaymentList>

    <ShippingCostList>
      <ShippingCost>
        <ShippingCode>$shipping_name</ShippingCode>
        <ShippingAmount>$shipping_amount</ShippingAmount>
        <ShippingDescription></ShippingDescription>
      </ShippingCost>
    </ShippingCostList>
    
    <SaleOrderLineList>
      $lignes_produit
    </SaleOrderLineList>
    
  </SaleOrder>

EOT;
    }
  }
  
  
  Header ('Content-Type: text/xml');
  header ('Content-Disposition: attachment; filename=export_all_orders_' . date ('dmY') . '_' . date ('His') . '.xml');


  echo <<<EOT
<?xml version="1.0" encoding="UTF-8" ?>
<GulliverExport>
  <SaleOrderList>
    $XML_SaleOrderlist
  </SaleOrderList>
</GulliverExport>
EOT;
  
  exit;
}


//Retourne la cl de connexion au catalogue
//Elle est renseigne dans les vars de configs du module
function G_get_api_key ()
{
  $api_key_query = tep_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key='MODULE_HEADER_TAGS_GULLIVER_API_KEY'");
  $api_key_infos = tep_db_fetch_array($api_key_query);
  $api_key = $api_key_infos["configuration_value"];
  return $api_key;
}


function G_displayLine ($Tdata, $has_delim = true) 
{
  $T = array();
  foreach ($Tdata as $s) {
    // On supprime les retours  la ligne et le sparateur.
    $s = preg_replace ("/[\r\n]+/", " ", $s);
    // Codage CSV avec "
    if ($has_delim)
      $s = preg_replace ('/"/', '""', $s);
    else
      $s = preg_replace ('/;/', ' ', $s);
    
    if(defined('CHARSET'))#donne l'encodage utilis sur le site
      $s = iconv (CHARSET, 'ISO-8859-1//IGNORE//TRANSLIT', $s);
    
    if ($has_delim)
      $T[] = '"' . $s . '"';
    else
      $T[] = $s;
  }
  echo join (G_SEP, $T);
  echo G_EOL;
}


//Retourne le code ISO d'un pays  partir de l'ID OSCOMMERCE du pays
function G_get_iso_code_from_id_country_oscommerce ($id_country) 
{
  if($id_country == ''){return;}
  
  global $Tcache_countries_iso_code;
  
  
  if(!isset($Tcache_countries_iso_code[$id_country]))#on fait la requete
  {
    $query = "SELECT countries_iso_code_2 
                            FROM " . TABLE_COUNTRIES . "
                            WHERE countries_id=" . $id_country . "
                            LIMIT 0,1";
    $sql = tep_db_query ($query);
    $Tsql = tep_db_fetch_array ($sql);

    $Tcache_countries_iso_code[$id_country] = $Tsql["countries_iso_code_2"];

    return $Tsql["countries_iso_code_2"];
  }
  else#on utilise le cache
  {
    return $Tcache_countries_iso_code[$id_country];
  }
}


//Retourne le code ISO d'un pays  partir de son nom
function G_get_iso_code_from_country_name_oscommerce ($country_name) 
{
  if($country_name == ''){return;}
  
  global $Tcache_countries_name;
   
  if(!isset($Tcache_countries_name[$country_name]))#on fait la requete
  {
    $query = "SELECT countries_iso_code_2 
                            FROM " . TABLE_COUNTRIES . "
                            WHERE countries_name='" . $country_name . "'" . "
                            LIMIT 0,1";
    $sql = tep_db_query ($query);
    $Tsql = tep_db_fetch_array ($sql);

    $Tcache_countries_name[$country_name] = $Tsql["countries_iso_code_2"];

    return $Tsql["countries_iso_code_2"];
  }
  else#on utilise le cache
  {
    return $Tcache_countries_name[$country_name];
  }
}


//Parsing XML
function G_XE ($_value)
{
  $_value = preg_replace ('/[\x0-\x1f]/', ' ', $_value);
  $_value = str_replace ('<', '&lt;', $_value);
  $_value = str_replace ('>', '&gt;', $_value);
  $_value = str_replace ('&', '&amp;', $_value);

  return $_value;
}


//construit une rfrence produit format Gulliver (G!XXXXX)  partir de l'ID oscommerce du produit
function G_get_ProductRef_from_ProductId ($product_id)
{
  //////////A FAIRE GERER LES DECLINAISONS !!!! ID PROD DU TYPE 1{5}4{2}
  ///////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////


  //si c'est l'id d'une declinaison on construit l'id du generique
  if(strpos ($product_id, '{'))
    $product_id = substr ($product_id, 0,  strpos ($product_id, '{'));

  $ref = sprintf ('G!%05d', trim($product_id));
  return $ref;
}


function G_do_version ($info = 'BASIC')
{
  header ('Content-Type: text/plain; charset=iso-8859-1');
  
  // Version Export
  echo "VERSION=" . G_VERSION . "\n";
  echo "MODULE_OS_VERSION=2.3"."\n";
  if ($info == 'EXTENDED')
  {
    // Version OsCommerce
    if(defined('PROJECT_VERSION'))
      echo "OS_VERSION=" . PROJECT_VERSION . "\n";
  }
  
  exit (0);
}

function G_do_test ()
{
  header ('Content-Type: text/plain; charset=iso-8859-1');
  echo "OK\n";
  exit (0);
}

//verif le format de la date fournie pour l'export
function G_check_export_date ($day, $month, $year)
{
  $export_begin_day = (int)$day;
  $export_begin_month = (int)$month;
  $export_begin_year = (int)$year;
  
  if($export_begin_day < 1 || $export_begin_day > 31)
  {
    echo 'Erreur : la date saisie est incorrecte (jour invalide)';
    exit;
  }
  else if($export_begin_month < 1 || $export_begin_month > 12)
  {
    echo 'Erreur : la date saisie est incorrecte (mois invalide)';
    exit;
  }
  else if(strlen ($export_begin_year) != 4)
  {
    echo 'Erreur : la date saisie est incorrecte (anne invalide)';
    exit;
  }
  
  $export_begin_year = trim($export_begin_year);
  $export_begin_month = trim($export_begin_month); 
  $export_begin_day = trim($export_begin_day);
  
  if(strlen ($export_begin_year) == 1)
    $export_begin_year = '0'.$export_begin_year;
  if(strlen ($export_begin_month) == 1)
    $export_begin_month = '0'.$export_begin_month;
  if(strlen ($export_begin_day) == 1)
    $export_begin_day = '0'.$export_begin_day;
  
  $date = $export_begin_year.'-'.$export_begin_month.'-'.$export_begin_day.' 00:00:00';
  
  return $date;
}


//Retourne le select de choix de la langue pour les exports
function G_get_select_language_for_export ()
{
  $query = "SELECT languages_id, name 
			  FROM " . TABLE_LANGUAGES ."
                          WHERE 1";
          
  $sql = tep_db_query ($query);
  
  $options = '';
  while($Tsql = tep_db_fetch_array ($sql))
  {
    $options .= "<option value=\"".$Tsql["languages_id"]."\">".$Tsql["name"]."</option>";
  }
  
  $select =<<<EOT
<select name="select_id_lang">
  $options
</select>
EOT;
  
  return $select;
}

//retourne les langues de la boutique
function G_get_languages_infos ()
{
  $query = "SELECT languages_id, name, code 
			  FROM " . TABLE_LANGUAGES ."
                          WHERE 1";
          
  $sql = tep_db_query ($query);
  
  $Tlanguages = Array();
  $i = 0;
  while($Tsql = tep_db_fetch_array ($sql))
  {
    $Tlanguages[$i]['id_lang'] = $Tsql['languages_id'];
    $Tlanguages[$i]['name'] = $Tsql['name'];
    $Tlanguages[$i]['code'] = $Tsql['code'];
    
    $i++;
  }
  
  return $Tlanguages;
}

//Retourne un tablea des codes langues en fonction du id_lang
function Get_corresponding_idlang_codelang ()
{
  $query = "SELECT languages_id, code 
			  FROM " . TABLE_LANGUAGES ."
                          WHERE 1";
          
  $sql = tep_db_query ($query);
  
  $Tlang = Array();
  
  while($Tsql = tep_db_fetch_array ($sql))
  {
    $Tlang[ $Tsql['languages_id'] ] = $Tsql['code'];
  }
  
  return $Tlang;  
}

function G_do_search_order ()
{
  if (get_magic_quotes_gpc () == 1)
    $email = stripslashes ($_REQUEST ['email']);
  else
    $email = $_REQUEST ['email'];

  // 1. Trouver le id_customer
  $query = "SELECT customers_id
            FROM " . TABLE_CUSTOMERS . "
            WHERE customers_email_address='" . $email . "'";
    
  $sql = tep_db_query ($query);
  $Tsql = tep_db_fetch_array ($sql);

  
  if($Tsql != FALSE && isset($Tsql["customers_id"]) && !empty ($Tsql["customers_id"]))
  {
    $id_customer = $Tsql["customers_id"];

    // 2. Trouver la derniere commande.
    $query2 = "SELECT orders_id, date_purchased, orders_status, payment_method,
              (SELECT orders_status_name FROM " . TABLE_ORDERS_STATUS . " os WHERE o.orders_status=os.orders_status_id AND os.language_id=1) AS orders_status_name
              FROM " . TABLE_ORDERS . " o
              WHERE o.customers_id='" . $id_customer . "'";
    $sql2 = tep_db_query ($query2);
    
    
    $Torders = Array ();
    $i = 0;
    while($Tsql2 = tep_db_fetch_array ($sql2))
    {
      $Torders[$i]["id_order"] = $Tsql2["orders_id"];
      $Torders[$i]["date_add"] = $Tsql2["date_purchased"];
      $Torders[$i]["id_order_state"] = $Tsql2["orders_status"];
      $Torders[$i]["order_state"] = $Tsql2["orders_status_name"];
      $Torders[$i]["module"] = $Tsql2["payment_method"];
      
      $i++;
    }
    $nb_orders = count ($Torders);

    // 3. Vrifier la date.
    $date = 0;
    $id_order = 0;
    $module = '';
    $id_order_state = '';
    $order_state = '';
    foreach ($Torders as $Torder)
    {
      $d = $Torder['date_add'];
      if ($d > $date)
      {
        $id_order = $Torder['id_order'];
        $module = $Torder['module'];
        $id_order_state = $Torder['id_order_state'];
        $order_state = $Torder['order_state'];
        $date = $d;
      }
    }

    echo "$email;$id_customer;$nb_orders;$id_order;$date;$module;$id_order_state;$order_state\n";
  }
  else
  {
    echo "$email;0;0;0;;;;\n";
  }
  
  exit (0);
}


//retourne un tableau de correspondance
// $ Tstatus[ID_STATUS] = STATUS NAME
function G_get_correspondence_OrderStatusNames_OrderStatusId ()
{
  //Recuperation de tous les status possible
  $query = "SELECT *
            FROM " . TABLE_ORDERS_STATUS . "
            WHERE language_id = 2";
  
  $sql = tep_db_query ($query);

  $Tstatus = Array ();
  
  while($Tsql = tep_db_fetch_array ($sql))
  {  
    $Tstatus[$Tsql["orders_status_id"]] = $Tsql["orders_status_name"];
  }
  
  return $Tstatus;
}


// On teste la variable de session => SI OK => on donne acces au module
// Sinon formulaire d'identification => si identification OK => cration de la var de session
function G_verify_connection ()
{
  $sessionVarName = 'AccesModuleGulliver';
  $sessionVarValue = 'OK';
  
  $resultCreateSession = session_start(); 
  
  
  # TO DO
  # A ameliorer !
  # Si on ne peut pas crer de sssion sur le serveur
  #   => on donne acces au module
  # Il faut prvoir une solution alternative 
  # dans le cas ou la session ne peut pas etre cre
  if($resultCreateSession == FALSE) {return;}

  
  if(isset($_SESSION[$sessionVarName]) && $_SESSION[$sessionVarName] == $sessionVarValue)
  {
    //Var de session OK => Accs au module
    return; 
  }
  else
  {
    //Var session non prsente => formulaire d'identification
    if(isset($_REQUEST['ATTEMPT_CONNECTION']) && $_REQUEST['ATTEMPT_CONNECTION'] == 1)#Le formulaire de connection vient d'etre post
    {
      //Si pass+login ok => acces au module+creation var session
      if(isset($_REQUEST['login']) && isset($_REQUEST['pass']) && $_REQUEST['login'] == 'Admin'  && $_REQUEST['pass'] == 'Gulliver')
      {
        $_SESSION[$sessionVarName] = $sessionVarValue;
        return;
      }
      else//Sinon messsage d'erreur
      {
        $_SESSION[$sessionVarName] = FALSE;
        $msg = '<div class="error_connection">Erreur dans l\'identifiant ou le mot de passe.</div>';
      }
    }
    
    echo <<<EOT
<?xml version="1.0" encoding="windows-1252"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
  <head>
    <title>Module Gulliver eMailing pour OsCommerce</title>
    <style type="text/css">
      body
      {
        font-size:12px;
        font-family:arial;
      }
      #connection_area
      {
        clear: both;
        display: block;
        overflow: hidden;
        padding: 5px;
        width: 500px;
      }
      #connection_area .title
      {
        color: #FF6033;
        display: block;
        font-size: 22px;
        font-weight: bold;
        text-align: center;
        width: 100%;
      }
      #connection_area .subtitle
      {
        display: block;
        font-weight: bold;
        margin-top: 10px;
        text-align: center;
        width: 100%;
      }
      #connection_area .table_connection
      {
        display: block;
        margin-bottom: 10px;
        margin-top: 10px;
      }
      #connection_area .line
      {
        clear: both;
        display: block;
        margin-top: 10px;
        text-align: center;
        width: 100%;
      }
      #connection_area .line label
      {
      }
      #connection_area .line input
      {
      }
      #connection_area .error_connection
      {
        color: red;
        display: block;
        font-weight: bold;
        margin-top: 2px;
        text-align: center;
        width: 100%;
      }
    </style>
  </head>
    
  <body>
    
    <div id="connection_area">
      
      <div class="title">Accs au Module Gulliver</div>
      
      <div class="subtitle">Merci de vous identifier :</div>
      
      <form action="ModuleGulliver.php" method="post">
        <input type="hidden" value="1" name="ATTEMPT_CONNECTION" id="ATTEMPT_CONNECTION" />
        
        <div class="line">
          <label for="login"><strong>Identifiant :</strong></label>
          <input type="text" name="login" id="login"/>
        </div>
        <div class="line">
          <label for="pass"><strong>Mot de passe :</strong></label>
          <td><input type="password" name="pass" id="pass"/>
        </div>
        <div class="line">
          <input type="submit" name="connexion" value="VALIDER"/>
        </div>
    
      </form>
      $msg
    </div>
      
  </body>
</html>
EOT;
  }
 
  
  exit;
}//G_verify_connection ()
?>